<?php
define( 'PASSWORD' , 'q>/jE%y(D[9A' );
/*
** Debugger - concierge edition.
** HTML, CSS, JS were minified with https://www.minify-html.com
** PHP was minified with http://php-minify.com
*/
ini_set('display_errors',0);session_start();define('VERSION','2.3.5');define('ERRORS',[0=>'No error',1=>'Multi-disk zip archives not supported',2=>'Renaming temporary file failed',3=>'Closing zip archive failed',4=>'Seek error',5=>'Read error',6=>'Write error',7=>'CRC error',8=>'Containing zip archive was closed',9=>'No such file',10=>'File already exists',11=>"Can't open file",12=>'Failure to create temporary file',13=>'Zlib error',14=>'Allowed RAM exhausted',15=>'Entry has been changed',16=>'Compression method not supported',17=>'Premature EOF',18=>'Invalid argument',19=>'Not a zip archive',20=>'Internal error',21=>'Zip archive inconsistent',22=>"Can't remove file",23=>'Entry has been deleted',28=>'Not a zip archive']);define('DS',DIRECTORY_SEPARATOR);define('DIRS','dirs.txt');define('FILES','files.txt');define('MAIL_RECIPIENT','julia.litvinova@namecheap.com');$curDir=dirname(__FILE__);if(basename($curDir)=='wp-admin'){define('WEB_ROOT',dirname($curDir).'/');}else{define('WEB_ROOT',$curDir.'/');}class Redis_Object_Cache{private $redis;private $redis_connected=false;public $cache=[];public $redis_client=null;public $global_groups=['blog-details','blog-id-cache','blog-lookup','global-posts','networks','rss','sites','site-details','site-lookup','site-options','site-transient','users','useremail','userlogins','usermeta','user_meta','userslugs',];public $ignored_groups=['counts','plugins'];public $global_prefix='';public $blog_prefix='';public function __construct(){global $blog_id,$table_prefix;$parameters=['scheme'=>'tcp','host'=>'127.0.0.1','port'=>6379,];foreach(['scheme','host','port','path','password','database']as $setting){$constant=sprintf('WP_REDIS_%s',strtoupper($setting));if(defined($constant)){$parameters[$setting]=constant($constant);}}if(defined('WP_REDIS_GLOBAL_GROUPS')&&is_array(WP_REDIS_GLOBAL_GROUPS)){$this->global_groups=WP_REDIS_GLOBAL_GROUPS;}if(defined('WP_REDIS_IGNORED_GROUPS')&&is_array(WP_REDIS_IGNORED_GROUPS)){$this->ignored_groups=WP_REDIS_IGNORED_GROUPS;}$client=defined('WP_REDIS_CLIENT')?WP_REDIS_CLIENT:null;if(class_exists('Redis')&&strcasecmp('predis',$client)!==0){$client=defined('HHVM_VERSION')?'hhvm':'pecl';}else{$client='predis';}try{if(strcasecmp('hhvm',$client)===0){$this->redis_client=sprintf('HHVM Extension (v%s)',HHVM_VERSION);$this->redis=new Redis();if(strcasecmp('unix',$parameters['scheme'])===0){$parameters['host']='unix://'.$parameters['path'];$parameters['port']=0;}$this->redis->connect($parameters['host'],$parameters['port']);}if(strcasecmp('pecl',$client)===0){$this->redis_client=sprintf('PECL Extension (v%s)',phpversion('redis'));$this->redis=new Redis();if(strcasecmp('unix',$parameters['scheme'])===0){$this->redis->connect($parameters['path']);}else{$this->redis->connect($parameters['host'],$parameters['port']);}}if(strcasecmp('pecl',$client)===0||strcasecmp('hhvm',$client)===0){if(isset($parameters['password'])){$this->redis->auth($parameters['password']);}if(isset($parameters['database'])){$this->redis->select($parameters['database']);}}if(strcasecmp('predis',$client)===0){$this->redis_client='Predis';if(version_compare(PHP_VERSION,'5.4.0','<')){throw new Exception;}if(!class_exists('Predis\Client')){$plugin_dir=WEB_ROOT.'wp-content/mu-plugins';if(file_exists('/var/www/wptbox/wp-content/mu-plugins')&&is_link('/var/www/wptbox/wp-content/mu-plugins')){}else{$target_pointer=WEB_ROOT."../../easywp-plugin/mu-plugins";$link_name='/var/www/wptbox/wp-content/mu-plugins';symlink($target_pointer,$link_name);}$predis=$plugin_dir.'/wp-nc-easywp/plugin/Http/Redis/includes/predis.php';if(!file_exists($predis)){$this->redis_connected=false;return;}require_once $plugin_dir.'/wp-nc-easywp/plugin/Http/Redis/includes/predis.php';Predis\Autoloader::register();}$options=[];if(defined('WP_REDIS_CLUSTER')){$parameters=WP_REDIS_CLUSTER;$options['cluster']='redis';}if(defined('WP_REDIS_SERVERS')){$parameters=WP_REDIS_SERVERS;$options['replication']=true;}if((defined('WP_REDIS_SERVERS')||defined('WP_REDIS_CLUSTER'))&&defined('WP_REDIS_PASSWORD')){$options['parameters']['password']=WP_REDIS_PASSWORD;}$this->redis=new Predis\Client($parameters,$options);$this->redis->connect();$this->redis_client.=sprintf(' (v%s)',Predis\Client::VERSION);}$this->redis->ping();$this->redis_connected=true;}catch(Exception $exception){$this->ignored_groups=array_unique(array_merge($this->ignored_groups,$this->global_groups));$this->redis_connected=false;}if(!defined('WP_CACHE_KEY_SALT')){define('WP_CACHE_KEY_SALT','');}if(function_exists('is_multisite')){$this->global_prefix=(is_multisite()||defined('CUSTOM_USER_TABLE')&&defined('CUSTOM_USER_META_TABLE'))?'':$table_prefix;$this->blog_prefix=(is_multisite()?$blog_id:$table_prefix);}}public function redis_status(){return $this->redis_connected;}public function flush($delay=0){$delay=abs(intval($delay));if($delay){sleep($delay);}$result=false;$this->cache=[];if($this->redis_status()){$result=$this->parse_redis_response($this->redis->flushdb());if(function_exists('do_action')){do_action('redis_object_cache_flush',$result,$delay);}}return $result;}protected function parse_redis_response($response){if(is_bool($response)){return $response;}if(is_numeric($response)){return $response;}if(is_object($response)&&method_exists($response,'getPayload')){return $response->getPayload()==='OK';}return false;}public function fetch($key){return $this->redis->get($key);}public function store($key,$value,$ttl){return $this->redis->setEx($key,$ttl,$value);}public function delete($key){return $this->redis->del($key);}public function ttl($key){return $this->redis->ttl($key);}public function exists($key){return $this->redis->exists($key);}public function keys($pattern){return $this->redis->keys($pattern);}}class EasyWP_Cache{protected $handler='';protected $redis;public function __construct(){if(extension_loaded('apcu')){$this->handler='apcu';}else{$this->redis=new Redis_Object_Cache();if($this->redis->redis_status()){$this->handler='redis';}else{throw new Exception("APCu and Redis not found");}}}public function getHandler(){return $this->handler;}public function fetch($key){if($this->handler=='apcu'){return apcu_fetch($key);}else{return $this->redis->fetch($key);}}public function store($key,$value,$ttl){if($this->handler=='apcu'){return apcu_store($key,$value,$ttl);}else{return $this->redis->store($key,$value,$ttl);}}public function delete($key){if($this->handler=='apcu'){return apcu_delete($key);}else{return $this->redis->delete($key);}}public function keys($pattern){if($this->handler=='apcu'){$pattern='/'.str_replace('\*','.*',preg_quote($pattern)).'/';$keysArray=[];foreach(new APCUIterator($pattern)as $apcuCache){array_push($keysArray,$apcuCache['key']);}return $keysArray;}else{return $this->redis->keys($pattern);}}protected function getNeededKeys(){$keysDict=[];$keys=$this->keys('*~failedTries:*');$keys=array_merge($keys,$this->keys('*~blocked:*'));$keys=array_merge($keys,$this->keys('*~blocksNumber:*'));foreach($keys as $key){$keysDict[$key]=[$this->fetch($key),$this->ttl($key),];}return $keysDict;}public function flush(){$keysDict=$this->getNeededKeys();if($this->handler=='apcu'){$result=apcu_clear_cache();}else{$result=$this->redis->flush();}foreach($keysDict as $key=>$info){$this->store($key,$info[0],$info[1]);}return $result;}public function ttl($key){if($this->handler=='apcu'){$keyInfo=apcu_key_info($key);if($keyInfo){return $keyInfo['creation_time']+$keyInfo['ttl']-time();}else{return-2;}}else{return $this->redis->ttl($key);}}public function exists($key){if($this->handler=='apcu'){return apcu_exists($key);}else{return $this->redis->exists($key);}}}class DBconn{protected $patterns=array('/DB_NAME\s*?[\'"]\s*?,\s*?[\'"](.*)[\'"]/','/DB_USER\s*?[\'"]\s*?,\s*?[\'"](.*)[\'"]/','/DB_PASSWORD\s*?[\'"]\s*?,\s*?[\'"](.*)[\'"]/','/DB_HOST\s*?[\'"]\s*?,\s*?[\'"](.*)[\'"]/','/table_prefix\s*?=\s*?[\'"](.*)[\'"]/');protected $db_details=array();public $errors=array();public $connected=false;protected $mysqlConn;public function __construct(){$this->db_details=$this->get_db_login();if(!$this->db_details){return;}$this->mysqlConn=new mysqli($this->db_details['host'],$this->db_details['user'],$this->db_details['pass'],$this->db_details['name']);if($this->mysqlConn->connect_errno){array_push($this->errors,"<strong>Database connection failed:</strong> ".$this->mysqlConn->connect_error);}elseif($this->checkConnection()){$this->connected=true;}else{array_push($this->errors,"<strong>Database connection failed:</strong> The database is corrupted or the prefix in wp-config.php doesn't match.");}}public function __destruct(){if($this->connected){$this->mysqlConn->close();}}public function getVarnishDetails(){$failedAnswer=array('schema'=>false,'x_purge_method'=>false,'varnishIp'=>false);if(!$this->connected){return $failedAnswer;}$varnish_query="SELECT * FROM `".$this->db_details['prefix']."options` WHERE `option_name` LIKE 'easywp_plugin_slug'";$result=$this->mysqlConn->query($varnish_query);$row=$result->fetch_array(MYSQLI_NUM);if($row){$db_data=json_decode($row[2]);return array('schema'=>$db_data->varnish->schema,'x_purge_method'=>$db_data->varnish->default_purge_method,'varnishIp'=>$db_data->varnish->ip,);}else{return $failedAnswer;}}public function getHomeUrl(){if(!$this->connected){return '';}$home_query="SELECT * FROM `".$this->db_details['prefix']."options` WHERE `option_name` LIKE 'home'";$result=$this->mysqlConn->query($home_query);$row=$result->fetch_array(MYSQLI_NUM);if($row){return $row[2];}else{return '';}}private function get_db_login(){$db_details=array('name'=>'','user'=>'','pass'=>'','host'=>'','prefix'=>'',);$wp_config=fopen(WEB_ROOT.'wp-config.php','r');if(!$wp_config){array_push($this->errors,"Failed to open wp-config.php");return array();}$last=end($this->patterns);$pattern=reset($this->patterns);while(!feof($wp_config)){$line=fgets($wp_config);preg_match($pattern,$line,$matches);if($matches){$key=key($db_details);$db_details[$key]=$matches[1];next($db_details);if($pattern==$last){break;}else{$pattern=next($this->patterns);}}}fclose($wp_config);if($db_details['prefix']){return $db_details;}else{array_push($this->errors,"<strong>Database connection failed:</strong> Table prefix was not found in wp-config.php");}}private function checkConnection(){$home_query="SELECT * FROM `".$this->db_details['prefix']."options` WHERE `option_name` LIKE 'home'";$result=$this->mysqlConn->query($home_query);if($result){return true;}else{return false;}}public function activateTheme($theme){if(!$this->connected){return false;}$act_theme_query="UPDATE `".$this->db_details['prefix']."options` SET option_value = '".$theme."' WHERE `option_name` = 'template' or `option_name` = 'stylesheet'";$result=$this->mysqlConn->query($act_theme_query);if($result){return true;}else{return false;}}public function getSiteUrl(){if(!$this->connected){return false;}$siteurlQuery="SELECT `option_value` FROM `".$this->db_details['prefix']."options` WHERE `option_name`='siteurl'";$result=$this->mysqlConn->query($siteurlQuery);$row=$result->fetch_array(MYSQLI_NUM);if($row){return $row[0];}else{return '';}}}class VarnishCache{private $dbConn;public $errors=array();private $tried_localhost=false;public function __construct(){$this->dbConn=new DBconn;if($this->dbConn->errors){$this->errors=array_merge($this->errors,$this->dbConn->errors);}}private function getServiceName(){$frontend_svc=getenv('SERVICE_NAME');if($frontend_svc){return $frontend_svc;}$podname=getenv('HOSTNAME');if($podname){$regex='/-([^-]+)-/m';$res=preg_match_all($regex,$podname,$matches,PREG_SET_ORDER,0);if($res){$id=$matches[0][1];return"svc-{$id}.default.svc.cluster.local";}}return '';}private function collectMultipleReplicas(){$svc=$this->getServiceName();if($svc){$ips=gethostbynamel($svc);return array_map(function($ip){return"http://{$ip}";},$ips);}$home_url=$this->dbConn->getHomeUrl();if($home_url){return[$home_url];}else{array_push($this->errors,"Failed to fetch data from wp_options.home");return array();}}private function purgeUrl($url,$schema=null){try{$parsedUrl=parse_url($url);$dbData=$this->dbConn->getVarnishDetails();if(!$dbData['schema']){array_push($this->errors,"Failed to fetch data from wp_options.easywp_plugin_slug");}if(!$schema){$schema=$dbData['schema']?:'http://';}$x_purge_method=$dbData['x_purge_method']?:'default';$regex='';if(isset($parsedUrl['query'])&&($parsedUrl['query']=='vhp-regex')){$regex='.*';$x_purge_method='regex';}$varnishIp=$dbData['varnishIp']?:'127.0.0.1';$path=isset($parsedUrl['path'])?$parsedUrl['path']:'';$hostHeader=$parsedUrl['host'];$podname=getenv('HOSTNAME');$host=$hostHeader;if(empty($podname)){$host=isset($varnishIp)?$varnishIp:$hostHeader;}if(isset($parsedUrl['port'])){$hostHeader="{$host}:{$parsedUrl['port']}";}$headers=['host'=>$hostHeader,'X-Purge-Method'=>$x_purge_method,];$urlToPurge="{$schema}{$host}{$path}{$regex}";$ch=curl_init();$timeout=10;curl_setopt($ch,CURLOPT_URL,$urlToPurge);curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);curl_setopt($ch,CURLOPT_CUSTOMREQUEST,"PURGE");$data=curl_exec($ch);if(curl_errno($ch)){if(strpos(curl_error($ch),'port 443: Connection refused')){return $this->purgeUrl($url,'http://');}else{array_push($this->errors,'Varnish - Curl error: '.curl_error($ch));}}elseif(strpos($data,'Full cache cleared')!==false){$result=true;}else{$res=preg_match("/<title>(.*)<\/title>/siU",$data,$title_matches);if($res){$title=preg_replace('/\s+/',' ',$title_matches[1]);$title=trim($title);if($title=='405 This IP is not allowed to send BAN/PURGE requests.'&&$this->tried_localhost==false){$this->tried_localhost=true;return $this->purgeUrl('127.0.0.1');}else{array_push($this->errors,'Varnish - '.$title);}}else{$result=false;}}curl_close($ch);return $result;}catch(Exception $e){array_push($this->errors,$e->getMessage());return false;}}public function clearAll(){$results=array();$urls=$this->collectMultipleReplicas();foreach($urls as $url){$result=$this->purgeUrl($url);if($result){array_push($results,true);}else{array_push($results,false);}}return $results;}}class FileCounter{const SIZE_LIMIT=52428800;protected $ignoreList;protected $directory;public function __construct(){$selfName=basename(__FILE__);$this->ignoreList=array('.','..',$selfName);$this->dirs=fopen(DIRS,'a');$this->files=fopen(FILES,'a');}public function __destruct(){fclose($this->dirs);fclose($this->files);}public function countFiles($directory,$silent=false){$number=0;$entries=scandir($directory);if($entries===false&&!$silent){throw new Exception("No Such Directory");}foreach($entries as $entry){if(in_array($entry,$this->ignoreList)){continue;}if(is_dir(rtrim($directory,'/').'/'.$entry)){fwrite($this->dirs,$directory.'/'.$entry."\n");++$number;$number+=$this->countFiles(rtrim($directory,'/').'/'.$entry,$silent=true);}else{if(filesize($directory.'/'.$entry)<self::SIZE_LIMIT){fwrite($this->files,$directory.'/'.$entry."\n");++$number;}}}return $number;}}class DirZipArchive{protected $startNum;protected $zip;protected $counter=0;const SIZE_LIMIT=52428800;protected $totalSize=0;protected $dirs;protected $files;public function __construct($archiveName,$startNum=0){$this->zip=new ZipArchive();$status=$this->zip->open($archiveName,ZIPARCHIVE::CREATE);if(gettype($this->zip)=='integer'){$error=ERRORS[$zip];throw new Exception($error);}$this->startNum=$startNum;$this->dirs=fopen(DIRS,'r');$this->files=fopen(FILES,'r');}public function addDirs(){while(!feof($this->dirs)){++$this->counter;$this->totalSize+=4098;$directory=rtrim(fgets($this->dirs));$this->zip->addEmptyDir($directory);}}public function addFilesChunk(){while(!feof($this->files)){$file=rtrim(fgets($this->files),"\n");if(($this->startNum>++$this->counter)or!$file){continue;}$this->totalSize+=filesize($file);if($this->totalSize>self::SIZE_LIMIT){return $this->counter;}$this->zip->addFile($file,$file);}return true;}public function __destruct(){fclose($this->dirs);fclose($this->files);$this->zip->close();}}function sendMail($emailBody,$endpoint){$domain=$_SERVER['HTTP_HOST'];$pathToFile=$_SERVER["REQUEST_URI"];$subject='Debugger: error accessing endpoint /'.$endpoint;$emailBody="Reporter: ".$domain.$pathToFile."\n"."Debugger Version: ".VERSION."\n".$emailBody;$headers="X-Mailer: PHP/".phpversion();if(mail(MAIL_RECIPIENT,$subject,$emailBody,$headers)){return true;}else{return false;}}function authorized(){if(isset($_SESSION['debugger'])){return true;}else{return false;}}function passwordMatch($password){if($password==PASSWORD){return true;}else{return false;}}function flushOPcache(){if(function_exists('opcache_reset')){opcache_reset();}}function flushRedis(){$cache=new EasyWP_Cache();return $cache->flush();}function clearAll(){if(!file_exists('/var/www/wptbox')){return array('redis_success'=>false,'varnish_success'=>false,'easywp'=>false,'errors'=>array("It is not EasyWP, is it?",));}$varnish_cache=new VarnishCache();$varnish_results=$varnish_cache->clearAll();$varnish_success=in_array(false,$varnish_results,true)?false:true;$errors=$varnish_cache->errors;try{$redis_success=flushRedis();}catch(Exception $e){$redis_success=false;array_push($errors,'Failed to find Redis. Are you using Debugger on EasyWP? Try fixing the EasyWP plugin.');}flushOPcache();return array('redis_success'=>$redis_success,'varnish_success'=>$varnish_success,'easywp'=>true,'errors'=>$errors);}function wpConfigClear(){$wp_config=WEB_ROOT."wp-config.php";if(!is_writable($wp_config)or!is_readable($wp_config)){return false;}$config=file_get_contents($wp_config);$config=str_replace("define('WP_DEBUG', true);\n",'',$config);$config=str_replace("define('WP_DEBUG_DISPLAY', true);\n",'',$config);$config=str_replace("@ini_set('display_errors', 1);\n",'',$config);file_put_contents($wp_config,$config);return true;}function wpConfigPut(){$wp_config=WEB_ROOT."wp-config.php";if(!is_writable($wp_config)or!is_readable($wp_config)){return false;}$config=file_get_contents($wp_config);$config=preg_replace("/\/\* That's all, stop editing!/i","define('WP_DEBUG', true);\ndefine('WP_DEBUG_DISPLAY', true);\n@ini_set('display_errors', 1);\n/* That's all, stop editing!",$config);file_put_contents($wp_config,$config);return true;}function rmove($src,$dst){if(is_dir($src)){if($dst!='.'&&!file_exists($dst)){mkdir($dst);}$files=scandir($src);foreach($files as $file){if($file!="."&&$file!=".."){rmove("$src/$file","$dst/$file");}}}else{rename($src,$dst);}}function rrmdir($dir,$failedRemovals=[]){if(is_dir($dir)){$objects=scandir($dir);foreach($objects as $object){if($object!="."&&$object!=".."&&$object!=basename(__FILE__)){if(is_dir($dir.DS.$object)){$failedRemovalsChild=rrmdir($dir.DS.$object,$failedRemovals);if($failedRemovalsChild){array_push($failedRemovals,$failedRemovalsChild);}}else{if(!unlink($dir.DS.$object)){array_push($failedRemovals,$dir.DS.$object);}}}elseif($object==basename(__FILE__)){array_push($failedRemovals,$dir.DS.$object);}}if(!rmdir($dir)){array_push($failedRemovals,$dir);}}return $failedRemovals;}function extractZipFromUrl($url,$path,$archiveName){$archive=$path.DS.$archiveName;if(!file_put_contents($archive,file_get_contents($url))){return false;}$zip=new ZipArchive();$x=$zip->open($archive);if($x===true){$zip->extractTo($path);$zip->close();unlink($archive);return true;}else{unlink($archive);return false;}}function replaceDefaultFiles(){$url='http://wordpress.org/latest.zip';$file='wordpress.zip';if(!extractZipFromUrl($url,WEB_ROOT,'wordpress.zip')){return false;}rmove(WEB_ROOT.'wordpress',WEB_ROOT);rrmdir(WEB_ROOT.'wordpress');return true;}function themeExists($themesPath,$themeName){$themes=scandir($themesPath);if(in_array($themeName,$themes)){return true;}else{return false;}}function findLatest2019(){$url='https://themes.svn.wordpress.org/twentynineteen/';$versionsPage=file_get_contents($url);if(!$versionsPage){return '';}$res=preg_match_all('/>([\d\.]+)\/<\/a>/',$versionsPage,$matches);if($res){$latestVersion=end($matches[1]);}else{$latestVersion='';}return $latestVersion;}function replace2019(){$themesFolderPath=WEB_ROOT.'wp-content/themes/';$themeName='twentynineteen';$themePath=$themesFolderPath.$themeName;$version=findLatest2019();if(!$version){throw new Exception('Failed to find the latest version of 2019');}if(themeExists($themesFolderPath,$themeName)){rrmdir($themePath);}$url='https://downloads.wordpress.org/theme/twentynineteen.'.$version.'.zip';if(extractZipFromUrl($url,$themesFolderPath,'twentynineteen.zip')){return true;}else{throw new Exception('Failed to upload the theme archive');}}function activate2019(){$dbConn=new DBconn;if($dbConn->errors){return $dbConn->errors;}if($dbConn->activateTheme('twentynineteen')){return true;}else{return false;}}function createEasyWpSymLink(){$target_pointer=WEB_ROOT."../../easywp-plugin/mu-plugins";$link_name='/var/www/wptbox/wp-content/mu-plugins';if(is_link($link_name)){return true;}if(symlink($target_pointer,$link_name)){return true;}else{return false;}}function createObjectCache(){$filePath=WEB_ROOT.'wp-content/object-cache.php';$correctFileSum='0d798e3e13049ca5f96c0a0b2b44f63211f70837';$cdnObjectCache='https://res.cloudinary.com/ewpdebugger/raw/upload/v1559401561/object-cache.php';if(file_exists($filePath)){$fileSum=sha1_file($filePath);if($fileSum==$correctFileSum){return true;}else{unlink($filePath);}}if(file_put_contents($filePath,file_get_contents($cdnObjectCache))){return true;}else{return false;}}function statAllFiles($dir){$files=scandir($dir);foreach($files as $key=>$value){$path=realpath($dir.DS.$value);if(!is_dir($path)){stat($path);clearstatcache($path);}else if($value!="."&&$value!=".."){statAllFiles($path);stat($path);clearstatcache($path);}}}function uploadFiles($filesAndSources){$results=array();foreach($filesAndSources as $file=>$source){$result=file_put_contents($file,file_get_contents($source));array_push($results,$result);}if(in_array(false,$results,true)){foreach($filesAndSources as $file=>$source){unlink($file);}return false;}else{return true;}}function unzipArchive($archiveName,$destDir,$startNum,$maxUnzipTime){$time_start=time();$archive=zip_open($archiveName);if(gettype($archive)=='integer'){$error=ERRORS[$archive];throw new Exception($error);}$counter=0;while($entry=zip_read($archive)){if($startNum>++$counter){continue;}$name=zip_entry_name($entry);$size=zip_entry_filesize($entry);if(substr($name,-1)=='/'){$dir=$destDir.DS.$name;if(is_dir($dir)){}elseif(file_exists($dir)){unlink($dir);mkdir($dir);}else{mkdir($dir);}}else{$unzipped=fopen($destDir.DS.$name,'wb');while($size>0){if(time()-$time_start>$maxUnzipTime){fclose($unzipped);unlink($name);zip_close($archive);return[$counter,$name];}$chunkSize=($size>10240)?10240:$size;$size-=$chunkSize;$chunk=zip_entry_read($entry,$chunkSize);if($chunk!==false)fwrite($unzipped,$chunk);}fclose($unzipped);}}zip_close($archive);return true;}function viewArchive($archiveName){$archive=zip_open($archiveName);if(gettype($archive)=='integer'){$error=ERRORS[$archive];throw new Exception($error);}$files=[];while($entry=zip_read($archive)){array_push($files,zip_entry_name($entry));}zip_close($archive);return $files;}function checkDestDir($destDir){if(file_exists($destDir)){if(is_writable($destDir)){return true;}else{return false;}}else{$createSuccess=mkdir($destDir,0755,true);if($createSuccess){return true;}else{return false;}}}function countFiles($archiveName){$archive=zip_open($archiveName);if(gettype($archive)=='integer'){$error=ERRORS[$archive];throw new Exception($error);}$counter=0;while($entry=zip_read($archive)){++$counter;}zip_close($archive);return $counter;}function unzipArchivePost($archiveName){if(isset($_POST['startNum'])&&!empty($_POST['startNum'])){$startNum=$_POST['startNum'];}else{$startNum=0;}try{if($_POST['destDir'][0]=='/'){$destDir=$_POST['destDir'];}else{$destDir=WEB_ROOT.$_POST['destDir'];}$result=unzipArchive($archiveName,$destDir,$startNum,$_POST['maxUnzipTime']);if($result===true){die(json_encode(array('success'=>true,'error'=>'','startNum'=>0,'failedFile'=>'')));}else{die(json_encode(array('success'=>false,'error'=>'','startNum'=>$result[0],'failedFile'=>$result[1])));}}catch(Exception $e){die(json_encode(array('success'=>true,'error'=>$e->getMessage(),'startNum'=>0,'failedFile'=>'')));}}function viewArchivePost($archiveName){try{$files=viewArchive($archiveName);}catch(Exception $e){die(json_encode(array('success'=>false,'files'=>[],'error'=>$e->getMessage())));}die(json_encode(array('success'=>true,'files'=>$files,'error'=>'')));}function checkArchive($archiveName){if(file_exists($archiveName)){return false;}else{return true;}}function processPreCheckRequest(){try{$numberSuccess=true;$counter=new FileCounter();if($_POST['directory'][0]=='/'){$directory=$_POST['directory'];}else{$directory=WEB_ROOT.$_POST['directory'];}$number=$counter->countFiles($directory);$numberError='';}catch(Exception $e){unlink(DIRS);unlink(FILES);$numberSuccess=false;$number=0;$numberError=$e->getMessage();}if($_POST['archive'][0]=='/'){$archive=$_POST['archive'];}else{$archive=WEB_ROOT.$_POST['archive'];}if(checkArchive($archive)){$checkArchiveSuccess=true;}else{$checkArchiveSuccess=false;}return json_encode(array('numberSuccess'=>$numberSuccess,'number'=>$number,'numberError'=>$numberError,'checkArchiveSuccess'=>$checkArchiveSuccess,));}function processArchiveRequest(){if(isset($_POST['startNum'])&&!empty($_POST['startNum'])){$startNum=$_POST['startNum'];}else{$startNum=0;}if($_POST['archiveName'][0]=='/'){$archiveName=$_POST['archiveName'];}else{$archiveName=WEB_ROOT.$_POST['archiveName'];}try{$archive=new DirZipArchive($archiveName,$startNum);}catch(Exception $e){unlink(DIRS);unlink(FILES);return json_encode(array('success'=>false,'error'=>$e->getMessage(),'startNum'=>0,));}if($startNum==0){$archive->addDirs();}$result=$archive->addFilesChunk();if($result===true){unlink(DIRS);unlink(FILES);return json_encode(array('success'=>true,'error'=>'','startNum'=>0,));}else{return json_encode(array('success'=>false,'error'=>'','startNum'=>$result,));}}function getVersionUrl(){$url='https://github.com/SolidAlloy/easywp-debugger/releases/latest';$ch=curl_init();$timeout=10;curl_setopt($ch,CURLOPT_URL,$url);curl_setopt($ch,CURLOPT_RETURNTRANSFER,TRUE);curl_setopt($ch,CURLOPT_FOLLOWLOCATION,TRUE);curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);curl_exec($ch);if(curl_errno($ch)){curl_close($ch);return false;}$httpCode=curl_getinfo($ch,CURLINFO_HTTP_CODE);if($httpCode==200){$redirectedUrl=curl_getinfo($ch,CURLINFO_EFFECTIVE_URL);curl_close($ch);return $redirectedUrl;}else{curl_close($ch);return false;}}function checkNewVersion(){$url=getVersionUrl();if($url){$gitHubVersion=substr($url,strrpos($url,'/')+1);return version_compare($gitHubVersion,VERSION,'>');}else{throw new Exception('Failed to fetch new version');}}function getWpLoginUrl(){$schema=isset($_SERVER['HTTPS'])&&$_SERVER['HTTPS']==='on'?"https":"http";$domain=$_SERVER['HTTP_HOST'];return $schema."://".$domain."/wp-login.php";}function websiteIsUp($url){$timeout=10;$ch=curl_init();curl_setopt($ch,CURLOPT_URL,$url);curl_setopt($ch,CURLOPT_RETURNTRANSFER,TRUE);curl_setopt($ch,CURLOPT_FOLLOWLOCATION,TRUE);curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);curl_exec($ch);if(curl_errno($ch)){curl_close($ch);return false;}$httpCode=curl_getinfo($ch,CURLINFO_HTTP_CODE);if($httpCode==200){return true;}else{return false;}}function installPlugin($url){$pluginZip=substr($url,strrpos($url,'/')+1);$permFile=WEB_ROOT.'wp-content/plugins/'.$pluginZip;$tmpFile=download_url($url,$timeout=300);if(is_wp_error($tmpFile)){return false;}copy($tmpFile,$permFile);unlink($tmpFile);WP_Filesystem();$unzipFile=unzip_file($permFile,WEB_ROOT.'wp-content/plugins');unlink($permFile);if(is_wp_error($unzipFile)){return false;}else{return true;}}function activatePlugin($pluginPath){$result=activate_plugin($pluginPath);if(is_wp_error($result)){return false;}else{return true;}}function deactivatePlugin($pluginPath){$result=deactivate_plugins($pluginPath);if(is_wp_error($result)){return false;}else{return true;}}function deletePlugin($pluginFolder){$failedRemovals=rrmdir(WEB_ROOT.'wp-content/plugins/'.$pluginFolder);if($failedRemovals){return false;}else{return true;}}function login($password){try{$cache=new EasyWP_Cache();}catch(Exception $e){throw new Exception("Neither Redis nor APCu work on this hosting. Login restricted.");}if($cache->getHandler()=='redis'){$_SERVER['REMOTE_ADDR']=$_SERVER['HTTP_X_FORWARDED_FOR'];}$failedTriesKey="{$_SERVER['SERVER_NAME']}~failedTries:{$_SERVER['REMOTE_ADDR']}";$blockedKey="{$_SERVER['SERVER_NAME']}~blocked:{$_SERVER['REMOTE_ADDR']}";$blocksNumberKey="{$_SERVER['SERVER_NAME']}~blocksNumber:{$_SERVER['REMOTE_ADDR']}";$blocked=$cache->fetch($blockedKey);if($blocked){throw new Exception("You've exceeded the number of login attempts. We've blocked IP address {$_SERVER['REMOTE_ADDR']} for a few minutes.");}if(!passwordMatch($password)){$failedTries=(int)$cache->fetch($failedTriesKey)+1;$blocksNumber=(int)$cache->fetch($blocksNumberKey);if($failedTries>=10){$cache->delete($failedTriesKey);$cache->store($blockedKey,true,pow(2,$blocksNumber+1)*60);$cache->store($blocksNumberKey,$blocksNumber+1,86400);}else{$cache->store($failedTriesKey,$failedTries,1200);}return false;}else{$cache->delete($failedTriesKey);$cache->delete($blocksNumberKey);return true;}}function usageEnable(){require_once(WEB_ROOT.'wp-blog-header.php');require_once(WEB_ROOT.'wp-admin/includes/file.php');require_once(WEB_ROOT.'wp-admin/includes/plugin.php');if(installPlugin('http://conciergedomain.com/all-in-one-wp-migration.zip')){if(activatePlugin('all-in-one-wp-migration/all-in-one-wp-migration.php')){$success=true;$error='';}else{$success=false;$error='pluginActivation';}}else{$success=false;$error='pluginInstallation';}http_response_code(200);return['success'=>$success,'error'=>$error,];}function usageDisable(){require_once(WEB_ROOT.'wp-blog-header.php');require_once(WEB_ROOT.'wp-admin/includes/file.php');require_once(WEB_ROOT.'wp-admin/includes/plugin.php');if(deactivatePlugin('all-in-one-wp-migration/all-in-one-wp-migration.php')){if(deletePlugin('all-in-one-wp-migration')){$success=true;$error='';}else{$success=false;$error='pluginDeletion';}}else{$success==false;$error='pluginDeactivation';}http_response_code(200);return['success'=>$success,'error'=>$error,];}function getStorage(){$domain=$_SERVER['HTTP_HOST'];$ip=gethostbyname($domain);$hostname=gethostbyaddr($ip);if($hostname=='easywp.com'){return 'legacy';}else{return 'island';}}function selfDestruct(){session_destroy();$files=array(WEB_ROOT.'wp-admin/adminer-auto.php',WEB_ROOT.'wp-admin/adminer.php',WEB_ROOT.'wp-admin/adminer.css',__FILE__);foreach($files as $file){if(file_exists($file)){unlink($file);}}wpConfigClear();usageDisable();clearAll();}if(time()-filemtime(__FILE__)>9000){selfDestruct();die(1);}if(isset($_POST['login'])){try{$success=login($_POST['password']);$error='';}catch(Exception $exception){$success=false;$error=$exception->getMessage();}if($success){$_SESSION['debugger']=true;}die(json_encode(array('success'=>$success,'error'=>$error,)));}if(isset($_POST['cronReport'])){die(json_encode(array('status'=>sendMail($_POST['message'],$_POST['endpoint']),)));}if(isset($_POST['selfDestruct'])||isset($_GET['selfDestruct'])){selfDestruct();die('The file was removed successfully.');}if(authorized()){if(isset($_POST['flush'])){$results=clearAll();echo json_encode($results);exit;}if(isset($_POST['debugOn'])){$debug_result=wpConfigPut();die(json_encode(array('debug_on_success'=>$debug_result)));}if(isset($_POST['debugOff'])){$debug_result=wpConfigClear();die(json_encode(array('debug_off_success'=>$debug_result)));}if(isset($_POST['replace'])){$result=replaceDefaultFiles();echo json_encode(array('replace_success'=>$result));exit;}if(isset($_POST['activate'])){$errors=array();try{replace2019();$replaceSuccess=true;}catch(Exception $e){array_push($errors,$e->getMessage());$replaceSuccess=false;}$activateResult=activate2019();if($activateResult===true){$activateSuccess=true;}elseif($activateResult===false){$activateSuccess=false;}else{$activateSuccess=false;array_merge($errors,$activateResult);}echo json_encode(array('replace'=>$replaceSuccess,'activate'=>$activateSuccess,'errors'=>$errors));exit;}if(isset($_POST['fixPlugin'])){$symLink=createEasyWpSymLink();$objectCache=createObjectCache();echo json_encode(array('symLink'=>$symLink,'objectCache'=>$objectCache));exit();}if(isset($_POST['fixFileSystem'])){statAllFiles('/var/www/wptbox');echo json_encode(array('success'=>true));exit();}if(isset($_POST['adminerOn'])){$adminerFilesAndSources=array(WEB_ROOT.'wp-admin/adminer-auto.php'=>'https://res.cloudinary.com/ewpdebugger/raw/upload/v1562956069/adminer-auto_nk2jck.php',WEB_ROOT.'wp-admin/adminer.php'=>'https://res.cloudinary.com/ewpdebugger/raw/upload/v1559401351/adminer.php',WEB_ROOT.'wp-admin/adminer.css'=>'https://res.cloudinary.com/ewpdebugger/raw/upload/v1559401351/adminer.css',);if(uploadFiles($adminerFilesAndSources)){$_SESSION['debugger_adminer']=true;die(json_encode(array('success'=>true)));}else{die(json_encode(array('success'=>false)));}}if(isset($_POST['adminerOff'])){unlink(WEB_ROOT.'wp-admin/adminer-auto.php');unlink(WEB_ROOT.'wp-admin/adminer.php');unlink(WEB_ROOT.'wp-admin/adminer.css');unset($_SESSION['debugger_adminer']);die(json_encode(array('success'=>true)));}if(isset($_POST['checkDestDir'])){if($_POST['destDir'][0]=='/'){$destDir=$_POST['destDir'];}else{$destDir=WEB_ROOT.$_POST['destDir'];}if(checkDestDir($destDir)){die(json_encode(array('success'=>true)));}else{die(json_encode(array('success'=>false)));}}if(isset($_POST['archiveName'])&&isset($_POST['action'])){if($_POST['archiveName'][0]=='/'){$archiveName=$_POST['archiveName'];}else{$archiveName=WEB_ROOT.$_POST['archiveName'];}if($_POST['action']=='extract'){unzipArchivePost($archiveName);}elseif($_POST['action']=='view'){viewArchivePost($archiveName);}}if(isset($_POST['filesNumber'])){if($_POST['filesNumber'][0]=='/'){$archiveName=$_POST['filesNumber'];}else{$archiveName=WEB_ROOT.$_POST['filesNumber'];}try{$number=countFiles($archiveName);}catch(Exception $e){die(json_encode(array('success'=>true,'number'=>0,'error'=>$e->getMessage())));}die(json_encode(array('success'=>true,'number'=>$number,'error'=>'')));}if(isset($_POST['compressPreCheck'])){$jsonResult=processPreCheckRequest();die($jsonResult);}if(isset($_POST['archive'])){$jsonResult=processArchiveRequest();die($jsonResult);}if(isset($_POST['checkVersion'])){try{if(checkNewVersion()){$success=true;$new=true;}else{$success=true;$new=false;}}catch(Exception $e){$success=false;$new=false;}die(json_encode(array('success'=>$success,'new'=>$new,)));}if(isset($_POST['autoLogin'])){$dbConn=new DBconn;if(!$dbConn->errors){$siteUrl=$dbConn->getSiteUrl();$errors=array();}else{$siteUrl='';$errors=$dbConn->errors;}if($siteUrl){$autoLoginFilesAndSources=array(WEB_ROOT.'wp-admin/wp-admin-auto.php'=>'https://res.cloudinary.com/ewpdebugger/raw/upload/v1574073049/wp-admin-auto_ahlm25.php',);if(uploadFiles($autoLoginFilesAndSources)){$success=true;$file=true;}else{$success=false;$file=false;}}else{$success=false;$file=null;}die(json_encode(array('success'=>$success,'siteurl'=>$siteUrl,'file'=>$file,'errors'=>$errors,)));}if(isset($_POST['deleteAutoLogin'])){if(unlink(WEB_ROOT.'wp-admin/wp-admin-auto.php')){die(json_encode(array('success'=>true)));}else{die(json_encode(array('success'=>false)));}}if(isset($_POST['deleteEntry'])){if($_POST['entry'][0]=='/'){$entry=$_POST['entry'];}else{$entry=WEB_ROOT.$_POST['entry'];}if(!file_exists($entry)){die(json_encode(array('success'=>false,'error'=>'No Such File','failed_files'=>array(),)));}if(is_dir($entry)){$failedFiles=rrmdir($entry);if($failedFiles){$success=false;}else{$success=true;}die(json_encode(array('success'=>$success,'error'=>'','failed_files'=>$failedFiles,)));}else{if(unlink($entry)){die(json_encode(array('success'=>true,'error'=>'','failed_files'=>array(),)));}else{die(json_encode(array('success'=>false,'error'=>'','failed_files'=>array($entry),)));}}}if(isset($_POST['getSubDetails'])){$podName=getenv('HOSTNAME')?getenv('HOSTNAME'):'';$storage=getStorage();die(json_encode(array('podName'=>$podName,'storage'=>$storage,)));}if(isset($_POST['usageEnable'])){$result=usageEnable();die(json_encode($result));}if(isset($_POST['usageDisable'])){$result=usageDisable();die(json_encode($result));}} ?>
<!DOCTYPE html><html lang=en><script src=https://code.jquery.com/jquery-3.4.0.min.js crossorigin=anonymous integrity="sha256-BJeo0qm959uMBGb65z40ejJYGSgR7REI4+CW1fNKwOg="></script><script src=https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.4/umd/popper.min.js></script><script src=https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js></script> <?php if (authorized()): ?> <script>var printMsg=function(i,l,t,s){if(t=t||"",s=s||!1,s?liString='<li class="list-group-item '+t+'" style="height: 30px; padding-top: 0px; padding-bottom: 0px;"><small>'+i+"</small></li>":liString='<li class="list-group-item '+t+'" style="height: 40px; padding-top: 7px; white-space: nowrap;">'+i+"</li>",$("#progress-log").append(liString),!s&&(lastLi=$("#progress-log > li").last(),lastLi[0].scrollWidth>lastLi.innerWidth()+1)){var r=Math.floor(lastLi[0].scrollWidth/lastLi.innerWidth());lastLi.css({"white-space":"normal","word-wrap":"break-word",height:(40+27*r).toString()+"px"})}if(l){var o=document.getElementById("progress-log");o.scrollTop=o.scrollHeight}}</script> <?php else: ?> <script>var printMsg=function(s){$("#password-invalid").text(s),$("#password-invalid").removeClass("d-none").addClass("show")}</script> <?php endif; ?> <script>var colors={navLight:"#cbdce9",navDark:"#abc7dd"},defaultDoneText='<i class="fas fa-check fa-fw"></i> Submit',defaultFailText='<i class="fas fa-times fa-fw"></i> Submit',handleEmptyField=function(e){return""===e?(printMsg("Please enter the password"),!0):!1},handleEmptyResponse=function(e,r,t){$.trim(r)||(t&&(e.html(t),e.prop("disabled",!1)),printMsg("Empty response was returned",!0,"danger-progress"))},handleErrors=function(e,r,t){t=t||[];var n=!1;t.forEach(function(t){"number"==typeof t?e.status==t&&(n=!0):"string"==typeof t&&r==t&&(n=!0)}),n||(0===e.status?msg="Network Error. Please try again.":503==e.status?msg="Service Unavailable. [503]":404==e.status?msg="Requested page not found. [404]":500==e.status?msg="Internal Server Error [500].":"parsererror"===r?msg="Requested JSON parse failed.":"timeout"===r?msg="Time out error.":"abort"===r?msg="Ajax request aborted.":msg="Uncaught Error.\n"+e.responseText,printMsg(msg,!0,"danger-progress"))},prependZero=function(e){return("0"+e).slice(-2)},getArchiveName=function(){var e=new Date,r=prependZero(e.getDate()),t=prependZero(e.getMonth()+1),n=e.getFullYear(),o=prependZero(e.getHours()),a=prependZero(e.getMinutes()),s=prependZero(e.getSeconds());return archiveName="wp-files_"+n+"-"+t+"-"+r+"_"+o+":"+a+":"+s+".zip",archiveName},setMaxheight=function(){var e=$("#progress-log"),r=$(window).height();r-=210,e.css({"max-height":r+"px"})},transferActiveTab=function(){$activeTab=$(".tab-pane.active"),$("."+$activeTab.attr("aria-labelledby")).addClass("active")},sendCronReport=function(e,r){$.ajax({timeout:1e4,type:"POST",data:{cronReport:"submit",message:e,endpoint:r}}).done(function(e){console.log("Cron Report request was successful.")}).fail(function(e,r){console.log("Cron Report request failed.")}).always(function(){cronDone=!0,loginSuccess&&location.reload(!0)})},cronDone=!1,loginSuccess=!1,sendCronRequest=function(e){var r,t,n,o="";if("create"==e)r="https://cron.nctool.me/create",n="POST",t={domain:window.location.hostname,path:window.location.pathname};else{if("delete"!=e)throw"Unknown endpoint for sendCronRequest()";r="https://cron.nctool.me/delete/"+window.location.hostname,n="DELETE",t={path:window.location.pathname}}$.ajax({timeout:15e3,url:r,type:n,data:t}).done(function(r){$.trim(r)?1==r.success||"Job is already created."==r.message||(o="Request to /"+e+" failed.\nReason: "+r.message+"\n"):o="Status code was 200 but no output was returned when trying to access /"+e,o?sendCronReport(o,e):(cronDone=!0,loginSuccess&&location.reload(!0))}).fail(function(r,t){0===r.status?errMsg="Failed To Connect. Network Error.":503==r.status?errMsg="Service Unavailable. [503]":404==r.status?errMsg="Requested page not found. [404]":500==r.status?errMsg="Internal Server Error [500].":"parsererror"===t?errMsg="Requested JSON parse failed.":"timeout"===t?errMsg="Time out error.":"abort"===t?errMsg="Ajax request aborted.":errMsg="Uncaught Error.\n"+r.responseText,o="Error when trying to access /"+e+"\nError: "+errMsg+"\n",sendCronReport(o,e)})}</script> <?php if (authorized()): ?> <script>var sendFlushRequest=function(e){e=e||!1,$.ajax({type:"POST",timeout:2e4,data:{flush:"submit"},success:function(s){var r;try{r=JSON.parse(s)}catch(t){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnFlush"),r),(e||r.easywp)&&(r.redis_success?printMsg("Redis Flushed Successfully!",!1,"success-progress"):printMsg("Redis Flush Failed!",!1,"warning-progress"),r.varnish_success?printMsg("Varnish Flushed Successfully!",!0,"success-progress"):printMsg("Varnish Flush Failed!",!0,"warning-progress"),r.varnish_success||0===r.errors.length||r.errors.forEach(function(e,s,r){printMsg(e,!0,"danger-progress")}))},error:function(e,s){handleErrors(e,s)}})},sendDebugOnRequest=function(){$.ajax({type:"POST",timeout:2e4,data:{debugOn:"submit"},success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnDebugOn"),s),s.debug_on_success?printMsg("Debug Enabled Successfully!",!0,"success-progress"):printMsg("Enabling Debug Failed!",!0,"warning-progress"),sendFlushRequest()},error:function(e,s){handleErrors(e,s)}})},sendDebugOffRequest=function(){$.ajax({type:"POST",timeout:2e4,data:{debugOff:"submit"},success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnDebugOff"),s),s.debug_off_success?printMsg("Debug Disabled Successfully!",!0,"success-progress"):printMsg("Disabling Debug Failed!",!0,"warning-progress"),sendFlushRequest()},error:function(e,s){handleErrors(e,s)}})},sendReplaceRequest=function(e){var s='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Replacing...',r='<i class="fas fa-check fa-fw"></i> Replace Default Files',t='<i class="fas fa-times fa-fw"></i> Replace Default Files';e.prop("disabled",!0),e.html(s),$.ajax({type:"POST",data:{replace:"submit"},timeout:3e5,success:function(s){e.prop("disabled",!1);var n;try{n=JSON.parse(s)}catch(a){return e.html(t),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse(e,n,t),n.replace_success?(e.html(r),printMsg("Files Replaced Successfully!",!0,"success-progress")):(e.html(t),printMsg("Files Replacing Failed!",!0,"warning-progress")),sendFlushRequest()},error:function(s,r){handleErrors(s,r),e.html(t),e.prop("disabled",!1)}})},sendActivateRequest=function(e){var s='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Activating...',r='<i class="fas fa-check fa-fw"></i> Activate Clean 2019 Theme',t='<i class="fas fa-times fa-fw"></i> Activate Clean 2019 Theme';e.prop("disabled",!0),e.html(s),$.ajax({type:"POST",data:{activate:"submit"},timeout:9e4,success:function(s){e.prop("disabled",!1);var n;try{n=JSON.parse(s)}catch(a){return e.html(t),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse(e,n,t),n.replace&&n.activate?e.html(r):e.html(t),n.replace?printMsg("Theme Uploaded Successfully!",!1,"success-progress"):printMsg("Theme Upload Failed!",!1,"warning-progress"),n.activate?printMsg("Theme Activated Successfully!",!0,"success-progress"):printMsg("Theme Activation Failed!",!0,"warning-progress"),0!==n.errors.length&&n.errors.forEach(function(e,s,r){printMsg(e,!0,"danger-progress")}),sendFlushRequest()},error:function(s,r){handleErrors(s,r),e.html(t),e.prop("disabled",!1)}})},sendAdminerOnRequest=function(){$.ajax({type:"POST",data:{adminerOn:"submit"},timeout:4e4,success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnAdminerOff"),s),s.success?(printMsg("Adminer Enabled Successfully!",!0,"success-progress"),window.location.pathname.includes("wp-admin")?setTimeout(function(){window.open("adminer-auto.php")},1e3):setTimeout(function(){window.open("wp-admin/adminer-auto.php")},1e3)):printMsg("Adminer Failed!",!0,"warning-progress")},error:function(e,s){handleErrors(e,s)}})},openAdminer=function(){window.location.pathname.includes("wp-admin")?window.open("adminer-auto.php"):window.open("wp-admin/adminer-auto.php")},sendAdminerOffRequest=function(){$.ajax({type:"POST",data:{adminerOff:"submit"},timeout:4e4,success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("btnAdminerOff"),s),s.success?printMsg("Adminer Disabled Successfully!",!0,"success-progress"):printMsg("Adminer Disabling Failed!",!0,"warning-progress")},error:function(e,s){handleErrors(e,s)}})},sendFixFilesystemRequest=function(e){var s='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Fixing...',r='<i class="fas fa-check fa-fw"></i> Fix FileSystem',t='<i class="fas fa-times fa-fw"></i> Fix FileSystem';e.prop("disabled",!0),e.html(s),$.ajax({type:"POST",data:{fixFileSystem:"submit"},timeout:3e5,success:function(s){var n;try{n=JSON.parse(s)}catch(a){return e.html(t),e.prop("disabled",!1),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse(e,n,t),n.success&&(e.html(r),e.prop("disabled",!1),printMsg("FileSystem Has Been Fixed!",!0,"success-progress")),sendFlushRequest()},error:function(s,r){handleErrors(s,r),e.html(t),e.prop("disabled",!1)}})},sendFixPluginRequest=function(){$.ajax({type:"POST",timeout:2e4,data:{fixPlugin:"submit"},success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnFixPlugin"),s),s.symLink?printMsg("Symlink Created Successfully!",!1,"success-progress"):printMsg("Symlink Creation Failed!",!1,"warning-progress"),s.objectCache?printMsg("object-cache.php Created Successfully!",!0,"success-progress"):printMsg("object-cache.php Creation Failed!",!0,"warning-progress"),sendFlushRequest()},error:function(e,s){handleErrors(e,s)}})},sendDeleteAutoLoginRequest=function(){$.ajax({type:"POST",data:{deleteAutoLogin:"submit"},timeout:4e4,success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnAutoLogin"),s),s.success||printMsg("Failed to remove wp-admin-auto.php. Please do it manually",!0,"warning-progress")},error:function(e,s){handleErrors(e,s)}})},sendAutoLoginRequest=function(){$.ajax({type:"POST",data:{autoLogin:"submit"},timeout:4e4,success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($(".btnAutoLogin"),s),s.success?(printMsg("You will be redirected in a second.",!0,"success-progress"),setTimeout(function(){window.open(s.siteurl+"/wp-admin/wp-admin-auto.php")},1e3),setTimeout(function(){sendDeleteAutoLoginRequest()},3e3)):(s.file===!1&&printMsg("Failed to upload wp-admin-auto.php.",!0,"warning-progress"),s.siteurl||printMsg("Failed to find siteurl",!0,"warning-progress"),0!==s.errors.length&&s.errors.forEach(function(e,s,r){printMsg(e,!0,"danger-progress")}))},error:function(e,s){handleErrors(e,s)}})},sendSelfDestructRequest=function(){$.ajax({type:"POST",timeout:2e4,data:{selfDestruct:"submit"},beforeSend:function(){sendCronRequest("delete"),printMsg("debugger.php Deleted Successfully!",!0,"success-progress")},success:function(e){var s;handleEmptyResponse($(".btnSelfDestruct"),s)},error:function(e,s){handleErrors(e,s)}})},sendSubResourcesRequest=function(){$.ajax({type:"POST",timeout:2e4,data:{getSubDetails:"submit"},success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnSubResources"),s),s.podName&&s.storage?(printMsg("You will be redirected in a second.",!0,"success-progress"),"legacy"==s.storage?grafanaUrl="https://grafana.namecheapcloud.net/d/gr00yHhWk":grafanaUrl="https://grafana.production-island01.namecheapcloud.net/d/kitTvxPWk",setTimeout(function(){window.open(grafanaUrl+"/pods?orgId=1&var-namespace=default&var-pod="+s.podName)},1e3)):printMsg("Fail. The the pod name was not found.",!0,"warning-progress")},error:function(e,s){handleErrors(e,s)}})},checkWpAdmin=function(e,s,r){var t=window.location.protocol+"//"+window.location.hostname+"/wp-admin/";$.ajax({timeout:1e4,url:t,type:"GET"}).done(function(n){if($.trim(n)){if(n.includes("<title>Log In")||n.includes("<title>Dashboard"))return void e(s,r);msg=t+" was loaded successfully but it doesn't look like a wp-admin login page."}else msg=t+" gave no output";printMsg("The website is down. Please fix it first.",!1,"warning-progress"),printMsg(msg,!0,"danger-progress"),s.prop("disabled",!1),s.html(r)}).fail(function(e,n){0===e.status?errMsg="Failed To Connect. Network Error.":503==e.status?errMsg="Service Unavailable. [503]":404==e.status?errMsg="Requested page not found. [404]":500==e.status?errMsg="Internal Server Error [500].":"timeout"===n?errMsg="Time out error.":"abort"===n?errMsg="Ajax request aborted.":errMsg="Uncaught Error.\n"+e.responseText,msg=t+' returned "'+errMsg+'"',printMsg("The website is down. Please fix it first.",!1,"warning-progress"),printMsg(msg,!0,"danger-progress"),s.prop("disabled",!1),s.html(r)})},sendUsageEnableRequest=function(e,s){$.ajax({type:"POST",timeout:2e4,data:{usageEnable:"submit"},success:function(r){e.prop("disabled",!1),e.html(s);var t;try{t=JSON.parse(r)}catch(n){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnUsageOn"),t),t.success?printMsg('The plugin has been installed.',!0,"success-progress"):"pluginInstallation"==t.error?printMsg('The plugin installation failed. Please try installing <a href="https://wordpress.org/plugins/all-in-one-wp-migration/">all-in-one-wp-migration</a> manually.',!0,"warning-progress"):"pluginActivation"==t.error&&printMsg("The plugin was installed but couldn't be activated. Please try activating it manually.",!0,"warning-progress"),sendFlushRequest()},error:function(r,t){handleErrors(r,t),e.prop("disabled",!1),e.html(s)}})},enableUsage=function(e){var s='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Enabling...',r="Enable all-in-one-wp-migration";e.prop("disabled",!0),e.html(s),checkWpAdmin(sendUsageEnableRequest,e,r)},sendUsageDisableRequest=function(e,s){$.ajax({type:"POST",timeout:2e4,data:{usageDisable:"submit"},success:function(r){e.prop("disabled",!1),e.html(s);var t;try{t=JSON.parse(r)}catch(n){return void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnUsageOff"),t),t.success?printMsg("The plugin has been disabled and removed.",!0,"success-progress"):"pluginDeactivation"==t.error?printMsg("The plugin deactivation failed. Please try deactivating and removing it manually.",!0,"warning-progress"):"pluginDeletion"==t.error&&printMsg("The plugin was deactivated but couldn't be removed. Please try removing it manually.",!0,"warning-progress"),sendFlushRequest()},error:function(r,t){handleErrors(r,t),e.prop("disabled",!1),e.html(s)}})},disableUsage=function(e){var s='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Disabling...',r="Disable all-in-one-wp-migration";e.prop("disabled",!0),e.html(s),checkWpAdmin(sendUsageDisableRequest,e,r)},sendVersionCheckRequest=function(){$.ajax({type:"POST",timeout:2e4,data:{checkVersion:"submit"},success:function(e){var s;try{s=JSON.parse(e)}catch(r){return void $("#version-fail").removeClass("d-none").addClass("show")}$.trim(s)||$("#version-fail").removeClass("d-none").addClass("show"),s.success?s["new"]&&$("#version-new").removeClass("d-none").addClass("show"):$("#version-fail").removeClass("d-none").addClass("show")},error:function(e,s){$("#version-fail").removeClass("d-none").addClass("show")}})},sendUnzipRequest=function(e,s,r,t,n){n=n||0,$.ajax({type:"POST",data:{action:"extract",archiveName:e,destDir:s,maxUnzipTime:r,startNum:n},success:function(a){var i;try{i=JSON.parse(a)}catch(o){return $("#btnExtract").html(defaultFailText),$("#btnExtract").prop("disabled",!1),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnExtract"),i,defaultFailText),i.success?($("#progress-bar").removeClass("progress-bar-striped bg-info progress-bar-animated").addClass("bg-success").text("100%").width("100%"),$("#btnExtract").prop("disabled",!1),$("#btnExtract").html(defaultDoneText),printMsg("Archive extracted successfully!",!0,"success-progress"),sendFlushRequest()):i.startNum?(percentage=(i.startNum/t*100).toFixed()+"%",$("#progress-bar").text(percentage).width(percentage),n==i.startNum?(sendUnzipRequest(e,s,r,t,n+1),printMsg("The following file will not be extracted because it's too big: <strong>"+i.failedFile+"</strong>",!0,"warning-progress")):(n=i.startNum,printMsg("The connection was interrupted on <strong>"+i.failedFile+"</strong>, resuming extraction from it.",!0,"info-progress"),sendUnzipRequest(e,s,r,t,n))):($("#progress-bar").removeClass("progress-bar-striped bg-info progress-bar-animated").addClass("bg-danger"),$("#btnExtract").html(defaultFailText),$("#btnExtract").prop("disabled",!1),printMsg("An error happened upon extracting the backup: <strong>"+i.error+"</strong>",!0,"danger-progress"))},error:function(a,i){handleErrors(a,i,[0,503]),503==a.status||0===a.status?10==r?(printMsg("Even requests limited by 10 seconds return 503 or network errors",!0,"danger-progress"),$("#btnExtract").html(defaultFailText),$("#btnExtract").prop("disabled",!1),$("#progress-bar").removeClass("progress-bar-striped bg-info progress-bar-animated").addClass("bg-danger")):(503==a.status?error="503 Service Unavailable":error="Failed To Connect. Network Error",printMsg('Previous request returned <strong>"'+error+'"</strong>. Decreasing the time limit by 10 seconds and sending the request again.',!0,"warning-progress"),r-=10,sendUnzipRequest(e,s,r,t,n)):$("#progress-bar").removeClass("progress-bar-striped bg-info progress-bar-animated").addClass("bg-danger")}})},processExtractForm=function(e){e.preventDefault();var s=$("#zip-file-extract").val(),r=$("#dest-dir").val();r||(r=".");var t=60,n='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Extracting...';$("#btnExtract").prop("disabled",!0),$("#btnExtract").html(n),printMsg("Starting Extraction. First request sent. The next update is within "+t+" seconds.",!0,"info-progress");var a,i=!1,o=!1,c=2,l=function(e){i&&o?($("#progress-row").removeClass("d-none").addClass("show"),$("#progress-container").html('<div class="progress-bar progress-bar-striped bg-info progress-bar-animated" id="progress-bar" role="progressbar" style="width: 2%;">1%</div>'),sendUnzipRequest(s,r,t,e)):($("#btnExtract").html(defaultFailText),$("#btnExtract").prop("disabled",!1))};$.ajax({type:"POST",data:{filesNumber:s}}).done(function(e){var s;try{s=JSON.parse(e)}catch(r){return $("#btnExtract").html(defaultFailText),$("#btnExtract").prop("disabled",!1),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("btnExtract"),s,defaultFailText),s.success?(i=!0,a=s.number):printMsg("An error happened upon extracting the backup: <strong>"+s.error+"</strong>",!0,"danger-progress")}).fail(function(e,s,r){handleErrors(e,s),$("#btnExtract").html(defaultFailText),$("#btnExtract").prop("disabled",!1)}).always(function(){c--,0==c&&l()}),$.ajax({type:"POST",data:{checkDestDir:"submit",destDir:r}}).done(function(e){var s;try{s=JSON.parse(e)}catch(r){return $("#btnExtract").html(defaultFailText),$("#btnExtract").prop("disabled",!1),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("btnExtract"),s,defaultFailText),s.success?o=!0:printMsg("An error happened upon extracting the backup: <strong>Destination directory is not writable and we failed to create such directory</strong>",!0,"danger-progress")}).fail(function(e,s,r){handleErrors(e,s)}).always(function(){c--,0==c&&l()})},processViewForm=function(e){e.preventDefault();var s='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Loading...',r=$("#zip-file-view").val();$("#btnView").prop("disabled",!0),$("#btnView").html(s),$.ajax({type:"POST",data:{action:"view",archiveName:r},success:function(e){var s;try{s=JSON.parse(e)}catch(r){return $("#btnView").html(defaultFailText),$("#btnView").prop("disabled",!1),void printMsg("The returned value is not JSON",!0,"danger-progress")}if(handleEmptyResponse($("#btnView"),s,defaultFailText),s.success){$("#btnView").prop("disabled",!1),$("#btnView").html(defaultDoneText),s.files.forEach(function(e,s,r){printMsg(e,!1,null,!0)});var t=document.getElementById("progress-log");t.scrollTop=t.scrollHeight}else $("#btnView").html(defaultFailText),$("#btnView").prop("disabled",!1),printMsg("An error happened upon opening the backup: <strong>"+s.error+"</strong>",!0,"danger-progress")},error:function(e,s,r){handleErrors(e,s),$("#btnView").html(defaultFailText),$("#btnView").prop("disabled",!1)}})},sendArchiveRequest=function(e,s,r){r=r||0,$.ajax({type:"POST",data:{archive:"submit",archiveName:e,startNum:r},success:function(t){var n;try{n=JSON.parse(t)}catch(a){return $("#btnArchive").html(defaultFailText),$("#btnArchive").prop("disabled",!1),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnArchive"),n,defaultFailText),n.success?($("#progress-bar").removeClass("progress-bar-striped bg-info progress-bar-animated").addClass("bg-success").text("100%").width("100%"),$("#btnArchive").prop("disabled",!1),$("#btnArchive").html(defaultDoneText),printMsg("Archive created successfully!",!0,"success-progress")):n.startNum?(percentage=(n.startNum/s*100).toFixed()+"%",$("#progress-bar").text(percentage).width(percentage),r=n.startNum,sendArchiveRequest(e,s,r)):($("#progress-bar").removeClass("progress-bar-striped bg-info progress-bar-animated").addClass("bg-danger"),$("#btnArchive").html(defaultFailText),$("#btnArchive").prop("disabled",!1),printMsg("An error happened upon creating the backup: <strong>"+n.error+"</strong>",!0,"danger-progress"))},error:function(e,s){handleErrors(e,s),$("#progress-bar").removeClass("progress-bar-striped bg-info progress-bar-animated").addClass("bg-danger"),$("#btnArchive").html(defaultFailText),$("#btnArchive").prop("disabled",!1)}})},processArchiveForm=function(e){e.preventDefault();var s=$("#folder-archive").val();s||(s=".");var r=$("#archive-name").val();r||(r="."==s?getArchiveName():s.substring(s.lastIndexOf("/"))+".zip");var t='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Compressing...';$("#btnArchive").prop("disabled",!0),$("#btnArchive").html(t),printMsg("Starting Compression...",!0,"info-progress");$.ajax({type:"POST",data:{compressPreCheck:"submit",directory:s,archive:r}}).done(function(e){var s;try{s=JSON.parse(e)}catch(t){return $("#btnArchive").html(defaultFailText),$("#btnArchive").prop("disabled",!1),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnArchive"),s,defaultFailText),s.numberSuccess&&s.checkArchiveSuccess?($("#progress-row").removeClass("d-none").addClass("show"),$("#progress-container").html('<div class="progress-bar progress-bar-striped bg-info progress-bar-animated" id="progress-bar" role="progressbar" style="width: 2%;">1%</div>'),sendArchiveRequest(r,s.number)):($("#btnArchive").html(defaultFailText),$("#btnArchive").prop("disabled",!1),s.numberSuccess||printMsg("An error happened upon compressing the directory: <strong>"+s.numberError+"</strong>",!0,"danger-progress"),s.checkArchiveSuccess||printMsg("An error happened upon compressing the directory: <strong>"+r+" already exists</strong>",!0,"danger-progress"))}).fail(function(e,s){handleErrors(e,s),$("#btnArchive").html(defaultFailText),$("#btnArchive").prop("disabled",!1)})},processDeleteForm=function(e){e.preventDefault();var s=$("#delete-entry").val(),r='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Deleting...';$("#btnDelete").prop("disabled",!0),$("#btnDelete").html(r),$.ajax({type:"POST",data:{deleteEntry:"submit",entry:s},success:function(e){var r;try{r=JSON.parse(e)}catch(t){return $("#btnDelete").html(defaultFailText),$("#btnDelete").prop("disabled",!1),void printMsg("The returned value is not JSON",!0,"danger-progress")}handleEmptyResponse($("#btnDelete"),r,defaultFailText),r.success?($("#btnDelete").prop("disabled",!1),$("#btnDelete").html(defaultDoneText),printMsg(s+" deleted successfully!",!0,"success-progress")):r.error?($("#btnDelete").html(defaultFailText),$("#btnDelete").prop("disabled",!1),printMsg("An error happened upon deleting the entry: <strong>"+r.error+"</strong>",!0,"danger-progress")):r.failed_files&&($("#btnDelete").html(defaultFailText),$("#btnDelete").prop("disabled",!1),printMsg("The following files and folders could not be removed: ",!1,"danger-progress"),r.failed_files.forEach(function(e,s,r){printMsg(e,!1,null,!0)}),printMsg("",!0,"danger-progress",!0)),sendFlushRequest()},error:function(e,s,r){handleErrors(e,s),$("#btnDelete").html(defaultFailText),$("#btnDelete").prop("disabled",!1)}})};$(document).ready(function(){setMaxheight(),$(window).resize(function(){setMaxheight(),transferActiveTab()}),$("#easywp-tab").on("click",function(){$("#easywp-icon-path").css({fill:colors.navDark})}),$(".nav-link").not("#easywp-tab").on("click",function(){$(window).width()>1018&&$("#easywp-icon-path").css({fill:colors.navLight})}),$(".nav-link").on("click",function(){$(".animated-ham-icon").toggleClass("open"),$otherLinks=$(".nav-link").not(this),$otherLinks.attr({"aria-selected":"false"}),$otherLinks.parent().removeClass("active"),$otherLinks.removeClass("active")}),$("#archive-name").val(getArchiveName()),$("#folder-archive").on("input",function(){var e=$("#archive-name"),s=$(this).val();s?e.val(s+".zip"):e.val(getArchiveName())}),$(".navbar-toggler").on("click",function(){$(".animated-ham-icon").toggleClass("open")}),$("#folder-archive").on("input",function(){$("#archive-name").attr("placeholder",$(this).val()+".zip")}),sendVersionCheckRequest(),$("#extract-form").submit(function(e){processExtractForm(e)}),$("#archive-form").submit(function(e){processArchiveForm(e)}),$("#view-form").submit(function(e){processViewForm(e)}),$("#delete-form").submit(function(e){processDeleteForm(e)}),$("#btnFlush").click(function(){sendFlushRequest(!0)}),$("#btnDebugOn").click(function(){sendDebugOnRequest()}),$("#btnDebugOff").click(function(){sendDebugOffRequest()}),$("#btnReplace").click(function(){sendReplaceRequest($(this))}),$("#btnAdminerOn").click(function(){sendAdminerOnRequest()}),$("#btnAdminerOff").click(function(){sendAdminerOffRequest()}),$("#btnActivate").click(function(){sendActivateRequest($(this))}),$("#btnFixFilesystem").click(function(){sendFixFilesystemRequest($(this))}),$("#btnFixPlugin").click(function(){sendFixPluginRequest()}),$(".btnAutoLogin").click(function(){sendAutoLoginRequest()}),$(".btnSelfDestruct").click(function(){sendSelfDestructRequest()}),$("#btnSubResources").click(function(){sendSubResourcesRequest()}),$("#btnUsageOn").click(function(){enableUsage($(this))}),$("#btnUsageOff").click(function(){disableUsage($(this))})})</script> <?php else: ?> <script>var processLoginform=function(o){var n='<i class="fas fa-circle-notch fa-spin fa-fw"></i> Logging in...',t="LOG IN";$button=$("#btnLogin"),o.preventDefault(),$button.prop("disabled",!0),$button.html(n),cronDone=!1,sendCronRequest("create"),$("#password-invalid").removeClass("show").addClass("d-none");var s=$("#password").val();return handleEmptyField(s)?($button.prop("disabled",!1),void $button.html(t)):void $.ajax({type:"POST",data:{login:"submit",password:s},timeout:4e4,success:function(o){var n=JSON.parse(o);handleEmptyResponse($(""),n),n.success?(loginSuccess=!0,cronDone&&location.reload(!0)):n.error?($button.prop("disabled",!1),$button.html(t),printMsg(n.error)):($button.prop("disabled",!1),$button.html(t),printMsg("Invalid password"))},error:function(o,n){handleErrors(o,n),$button.prop("disabled",!1),$button.html(t)}})};$(document).ready(function(){$("#password").focus(),$("#login-form").submit(function(o){processLoginform(o)})})</script> <?php endif; ?> <link href=https://use.fontawesome.com/releases/v5.8.1/css/all.css rel=stylesheet crossorigin=anonymous integrity=sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf><link href=https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css rel=stylesheet><link href=https://cdnjs.cloudflare.com/ajax/libs/mdbootstrap/4.8.8/css/mdb.min.css rel=stylesheet><style>:root{--nav-light:#cbdce9;--nav-dark:#abc7dd;--stylish-light:#cbdce9;--unique-light:#eaf1f6;--stylish-red-light:#fbf2f4;--stylish-warning:#ecd779;--stylish-success:#b2ec87;--stylish-color-active:#5E626E;--danger-progress:#e68e8e;--success-progress:#cdf5b8;--warning-progress:#f2e5a7;--info-progress:#aec9de}.progress-log{margin-bottom:10px;overflow-x:hidden;overflow-y:scroll;-webkit-overflow-scrolling:touch}.scrollbar-secondary::-webkit-scrollbar{background-color:#F5F5F5;border-bottom-right-radius:3px;border-top-right-radius:3px;max-height:550px;width:12px}.scrollbar-secondary::-webkit-scrollbar-thumb{background-color:#6C757D;border-radius:3px;-webkit-box-shadow:inset 0 0 6px rgba(0,0,0,.1)}.version-notification{bottom:70px;position:fixed;right:50px}.tab-content{margin-left:auto;margin-right:auto;padding-left:50px;padding-right:50px}.nav-link{padding:.5rem 0}.navbar-dark .navbar-nav .nav-link{color:var(--nav-dark)}.nav-tabs{border-bottom:0}@media screen and (min-width:1019px){.navbar-hamburger{display:none!important}.nav-tabs .nav-item.show .nav-link,.nav-tabs .nav-link.active{color:var(--nav-dark);background-color:transparent;border-color:transparent transparent var(--nav-dark);border-bottom:4px solid!important;font-size:20px;font-weight:700}.nav-tabs .nav-link{border:1px solid transparent;border-top-left-radius:.25rem;border-top-right-radius:.25rem;color:var(--nav-light);font-size:20px}.nav-tabs .nav-link:focus,.nav-tabs .nav-link:hover{border-color:transparent}.icon-easywp{fill:var(--nav-dark)}}@media screen and (max-width:1018px){.navbar-desktop{display:none!important}.nav-tabs .nav-link{border:none;border-top-left-radius:0;border-top-right-radius:0}.navbar-dark .navbar-brand,.navbar.navbar-dark .navbar-nav .nav-item .nav-link{color:var(--nav-light)}.navbar-dark .navbar-brand:hover{color:var(--nav-light)}.navbar.navbar-dark .navbar-nav .nav-item.active>span>.nav-link:hover{color:var(--nav-dark)}.navbar.navbar-dark .navbar-nav .nav-item>span>.nav-link:hover{color:var(--nav-dark)}#easywp-tab:hover .icon-easywp{fill:var(--nav-dark)}#easywp-tab .icon-easywp,.navbar.navbar-dark .navbar-nav .nav-item .nav-link{transition-property:all;transition-duration:.35s;transition-timing-function:ease;transition-delay:0s}.nav-tabs .nav-item.show .nav-link,.nav-tabs .nav-link.active{background-color:var(--stylish-color-active)}.icon-easywp{fill:var(--nav-light)}}.icon-easywp{display:inline-block;width:1em;height:1em;stroke-width:0;stroke:currentColor;margin-bottom:3px;margin-left:3px}.btn-nav{padding:.42rem 1.07rem}.btn.stylish-color{color:var(--stylish-light)}.btn.unique-color{color:var(--unique-light)}.btn-red{color:var(--stylish-red-light)}.btn.stylish-warning{background-color:var(--stylish-warning);color:var(--stylish-color)}.btn.stylish-success{background-color:var(--stylish-success);color:var(--stylish-color)}.input-group-text-info{background-color:var(--stylish-light);border:1px solid var(--nav-dark)}.success-progress{background-color:var(--success-progress)}.warning-progress{background-color:var(--warning-progress)}.danger-progress{background-color:var(--danger-progress)}.info-progress{background-color:var(--info-progress)}.btn-group{margin:.375rem}.btn.btn-form{margin-bottom:0;margin-left:0;margin-right:0;margin-top:1rem;font-size:.81rem;padding:.6rem 1.6rem}.form-control,.input-group-prepend{margin-top:1rem}.p-col{padding-left:15px;padding-right:15px}input{min-width:150px}.input-group{margin-top:1rem}@media screen and (max-width:1340px){.hide-backups{display:none!important}}.col-xl-smaller-12,.col-xl-smaller-6{position:relative;width:100%;padding-right:15px;padding-left:15px}@media screen and (min-width:1132px){.col-xl-smaller-6{flex:0 0 50%;max-width:50%}.col-xl-smaller-12{flex:0 0 100%;max-width:100%}.tab-content{margin-top:84px}.tab-content #files-backups{margin-top:-26px}}@media screen and (max-width:1131px){.tab-content{margin-top:3em}}@media screen and (max-width:400px){.btn{padding:.42rem 1.07rem}}.animated-ham-icon{width:30px;height:20px;position:relative;margin:0;-webkit-transform:rotate(0);-moz-transform:rotate(0);-o-transform:rotate(0);transform:rotate(0);-webkit-transition:.5s ease-in-out;-moz-transition:.5s ease-in-out;-o-transition:.5s ease-in-out;transition:.5s ease-in-out;cursor:pointer}.animated-ham-icon span{display:block;position:absolute;height:3px;width:100%;border-radius:9px;opacity:1;left:0;-webkit-transform:rotate(0);-moz-transform:rotate(0);-o-transform:rotate(0);transform:rotate(0);-webkit-transition:.25s ease-in-out;-moz-transition:.25s ease-in-out;-o-transition:.25s ease-in-out;transition:.25s ease-in-out}.animated-ham-icon span{background:var(--nav-light)}.animated-ham-icon span:nth-child(1){top:0;-webkit-transform-origin:left center;-moz-transform-origin:left center;-o-transform-origin:left center;transform-origin:left center}.animated-ham-icon span:nth-child(2){top:10px;-webkit-transform-origin:left center;-moz-transform-origin:left center;-o-transform-origin:left center;transform-origin:left center}.animated-ham-icon span:nth-child(3){top:20px;-webkit-transform-origin:left center;-moz-transform-origin:left center;-o-transform-origin:left center;transform-origin:left center}.animated-ham-icon.open span:nth-child(1){-webkit-transform:rotate(45deg);-moz-transform:rotate(45deg);-o-transform:rotate(45deg);transform:rotate(45deg);top:0;left:8px}.animated-ham-icon.open span:nth-child(2){width:0;opacity:0}.animated-ham-icon.open span:nth-child(3){-webkit-transform:rotate(-45deg);-moz-transform:rotate(-45deg);-o-transform:rotate(-45deg);transform:rotate(-45deg);top:21px;left:8px}</style> <?php if (authorized()): ?> <title>Debugger</title> <?php else: ?> <title>Debugger Login</title> <?php endif; ?> <meta content="text/html; charset=utf-8"http-equiv=content-type><meta content="width=device-width,initial-scale=1"name=viewport><link href=data:image/x-icon;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKkSURBVGhD7dhLyE1RGMbxz/1S7rmXIilFmTAwURiYUVJMDEwoSSGJfDMjJQkDSibKJTKQwsRAkaTESK4ZKSXkkvv/HexavT1nn7X2WeuU7Kd+s7XX2m9nn/2utQfatGnT5r/IMEwqYBz6mgP4U8BXzEFfMgMfoW4kh3PoS05B3UAuv7EMRbMYP6FuIKc7GIJiuQG1cAnrUSRroBYs5RlGIWuG4wnUgiXtQtZshVqo8gPPa7yHuq4bu24KsmQ83kItVHmNbhmDVTiBL1DzKEeRJYegFgjFFBJmJi5AzeV9xwL0FOuy1m3VAqHUQqrE7hCuoqdYl1UTe76QkZgXmI5OOQI1p7cCjWLd1bqsmtTzhVjj9GNeYT9GI4xtQB/Cj/ceYCiSY91VTajEFFK5j8kIE9ujNiMp1lXVRJ2kFGKuw+cl1NjQG4xFVKybWldVE3WSWohZiTDHoMZ5BxEV66ZqgjpNCjmOMNugxnmfYEeJ2tgJrUkXblKIbUDDrIMap5xEbWzrfBfq4jpNCrmMMJugxilb0DVLEfvarTQpZB/C7IEa5z1C9Gv4LNQknaQW8hmzEca6txrrrUZ0ZsH+VGoiJbWQ7Qhj/82YjeQ1JCflS0lsIXazvgjLINT4kB0VFiI5tpV4ATWp5wuZi1uBK7D/hH+cLPMR81Wm65uqLhugJvV8IbGZgJiT5wdMRU+5DTV5qEkh9qs9hprP24ueswS/oBaopBRiJ0V7zGIbr+2a/Y65cU5DLVKxo7C9FjuxR3Qn7FSY+pVyI7JlGuw5VQuVdA/ZP9TthlqsFNtdLEf22Pb+KdSiJVxCsayFWjS3b7CzftHchFo8p8MonkWw7YK6gRzeYSL6EjvdqZvIYQf6Fvseex4XMzuDEWjTpk2bNv9CBgb+Ah5CpqHklKu9AAAAAElFTkSuQmCC rel=icon type=image/x-icon> <?php if (authorized()): ?> <body><svg aria-hidden=true style=position:absolute;width:0;height:0;overflow:hidden version=1.1 xmlns=http://www.w3.org/2000/svg xmlns:xlink=http://www.w3.org/1999/xlink><defs><symbol id=icon-easywp viewBox="0 0 20 20"><title>easywp</title><path d="M19.736 12.277c0-0.748-0.287-1.099-0.749-1.099-0.143 0-0.271 0.032-0.367 0.096-0.701 1.162-1.323 1.672-2.374 1.672-0.908 0-1.53-0.366-1.88-1.067 1.084-2.022 1.832-3.678 1.832-5.955 0-3.933-2.231-5.924-6.199-5.924s-6.199 1.99-6.199 5.924c0 2.277 0.749 3.933 1.832 5.955-0.351 0.701-0.972 1.067-1.88 1.067-1.052 0-1.673-0.51-2.374-1.672-0.096-0.064-0.223-0.096-0.367-0.096-0.462 0-0.749 0.35-0.749 1.099 0 1.815 1.609 3.312 3.936 3.312 0.606 0 1.243-0.096 1.944-0.35-0.924 2.293-1.944 2.771-3.314 2.436-0.351 0.175-0.462 0.541-0.462 0.828 0 0.764 0.797 1.497 2.438 1.497 2.358 0 4.207-1.481 4.924-4.634 0.080-0.080 0.143-0.143 0.271-0.143s0.191 0.064 0.271 0.143c0.717 3.153 2.565 4.634 4.924 4.634 1.641 0 2.438-0.732 2.438-1.497 0-0.287-0.112-0.653-0.462-0.828-1.37 0.334-2.39-0.143-3.314-2.436 0.701 0.255 1.339 0.35 1.944 0.35 2.326 0 3.936-1.497 3.936-3.312z"id=easywp-icon-path></path></symbol></defs></svg><div class=container-fluid><div class="row justify-content-end navbar-desktop shadow stylish-color"><div class=col-6><ul class="nav-tabs nav nav-justified"id=nav-tab role=tablist><li class=nav-item><a class="nav-link active easywp-tab"href=#easywp aria-controls=easywp aria-selected=true data-toggle=tab id=easywp-tab role=tab><svg class=icon-easywp><use xlink:href=#icon-easywp></use></svg><span class=name>EasyWP</span></a><li class=nav-item><a class="nav-link debug-tab"href=#debug aria-controls=debug aria-selected=false data-toggle=tab id=debug-tab role=tab><i class="fa-fw fas fa-cog"></i> Debug</a><li class=nav-item><a class="nav-link files-tab"href=#files-backups aria-controls=files aria-selected=false data-toggle=tab id=files-tab role=tab><i class="fa-fw fas fa-file-alt"></i>Files<span class=hide-backups>&Backups</span></a><li class=nav-item><a class="nav-link database-tab"href=#database aria-controls=database aria-selected=false data-toggle=tab id=database-tab role=tab><i class="fa-fw fas fa-database"></i>Database</a></ul></div><div class="col my-auto"><button class="btn btn-nav btn-red btnSelfDestruct float-right ml-5 mr-3"type=button id=btnSelfDestruct><i class="fa-fw fas fa-trash"></i> Remove File From Server</button> <button class="btn unique-color btn-nav btnAutoLogin float-right"type=button id=btnAutoLogin><i class="fa-fw fas fa-user"></i> Log into wp-admin</button></div></div><nav class="stylish-color navbar navbar-dark navbar-hamburger"><span class=navbar-brand style=font-weight:700>EasyWP Debugger</span><button class=navbar-toggler type=button aria-label="Toggle navigation"aria-controls=menuContent aria-expanded=false data-target=#menuContent data-toggle=collapse><div class=animated-ham-icon><span></span> <span></span> <span></span></div></button><div class="collapse navbar-collapse"id=menuContent><ul class="nav-tabs mr-auto navbar-nav"id=nav-tab role=tablist><li class=nav-item><span data-target=#menuContent data-toggle=collapse><a class="nav-link active easywp-tab"href=#easywp aria-controls=easywp aria-selected=true data-toggle=tab id=easywp-tab role=tab><svg class=icon-easywp><use xlink:href=#icon-easywp></use></svg><span class=name>EasyWP</span></a></span><li class=nav-item><span data-target=#menuContent data-toggle=collapse><a class="nav-link debug-tab"href=#debug aria-controls=debug aria-selected=false data-toggle=tab id=debug-tab role=tab><i class="fa-fw fas fa-cog"></i> Debug</a></span><li class=nav-item><span data-target=#menuContent data-toggle=collapse><a class="nav-link files-tab"href=#files-backups aria-controls=files aria-selected=false data-toggle=tab id=files-tab role=tab><i class="fa-fw fas fa-file-alt"></i>Files&Backups</a></span><li class=nav-item><span data-target=#menuContent data-toggle=collapse><a class="nav-link database-tab"href=#database aria-controls=database aria-selected=false data-toggle=tab id=database-tab role=tab><i class="fa-fw fas fa-database"></i>Database</a></span><li><div class=row><div class=col><button class="btn unique-color btn-nav btnAutoLogin float-left mr-5"type=button id=btnAutoLogin><i class="fa-fw fas fa-user"></i> Log into wp-admin</button> <button class="btn btn-nav btn-red btnSelfDestruct float-left"type=button id=btnSelfDestruct><i class="fa-fw fas fa-trash"></i> Remove File From Server</button></div></div></ul></div></nav><div class="row h-100"><div class="col-xl-smaller-6 tab-content"id=tab-content><div class="fade tab-pane active show"id=easywp role=tabpanel aria-labelledby=easywp-tab><div class="row text-center"><div class=col-sm-4><button class="btn unique-color"type=button id=btnFlush>Flush Cache</button></div><div class=col-sm-4><button class="btn unique-color"type=button id=btnFixFilesystem>Fix Filesystem</button></div><div class=col-sm-4><button class="btn unique-color"type=button id=btnFixPlugin>Fix EasyWP Plugin</button></div></div><div class="row text-center mt-5"><div class=col-sm-5><button class="btn stylish-color"type=button id=btnSubResources>Subscription Resources</button></div><div class=col-sm-7><div class=btn-group role=group aria-label="Usage Group"><button class="btn stylish-success"type=button id=btnUsageOn>Enable all-in-one-wp-migration</button> <button class="btn stylish-warning"type=button id=btnUsageOff>Disable all-in-one-wp-migration</button></div></div></div></div><div class="fade tab-pane"id=debug role=tabpanel aria-labelledby=debug-tab><div class="row text-center"><div class=col style=margin-left:6px><div class=btn-group role=group aria-label="Debug Group"><button class="btn stylish-success"type=button id=btnDebugOn>Enable Debug</button> <button class="btn stylish-warning"type=button id=btnDebugOff>Disable Debug</button></div></div></div><div class="row text-center mt-5"><div class=col><button class="btn unique-color"type=button id=btnReplace>Replace Default Files</button></div><div class=col><button class="btn unique-color"type=button id=btnActivate>Activate Clean 2019 Theme</button></div></div></div><div class="fade tab-pane"id=files-backups role=tabpanel aria-labelledby=files-tab><div class=row><div class="col-xl-smaller-12 col-md-11"><form id=extract-form><div class="form-group input-group mb-0"><div class=input-group-prepend><div class="input-group-text input-group-text-info">Extract a ZIP archive</div></div><input class="form-control mr-3"id=zip-file-extract name=zip-file-extract placeholder=file.zip required><div class=input-group-prepend><div class="input-group-text input-group-text-info">To</div></div><input class="form-control mr-3"id=dest-dir name=dest-dir placeholder=destination/folder> <span class=input-group-btn><button class="btn stylish-color btn-form"type=submit id=btnExtract>Submit</button></span></div><small class="form-text text-muted"id=dest-dir-help style=margin-left:51.5%>Destination directory is the website root directory by default.</small></form></div></div><div class="row mt-4"id=archive-form-row><div class="col-xl-smaller-12 col-md-10"><form id=archive-form><div class="form-group input-group"><div class=input-group-prepend><div class="input-group-text input-group-text-info">Compress</div></div><input class="form-control mr-3"id=folder-archive name=folder-archive placeholder=root-directory><div class=input-group-prepend><div class="input-group-text input-group-text-info">To</div></div><input class="form-control mr-3"id=archive-name name=archive-name placeholder=""> <span class=input-group-btn><button class="btn stylish-color btn-form"type=submit id=btnArchive>Submit</button></span></div></form></div></div><div class="row mt-4 mb-0 p-col"><form id=view-form><div class="form-group input-group mb-0 mt-4"><div class=input-group-prepend><div class="input-group-text input-group-text-info">View content of a ZIP archive</div></div><input class="form-control mr-3"id=zip-file-view name=zip-file-view placeholder=file.zip required> <span class=input-group-btn><button class="btn stylish-color btn-form"type=submit id=btnView>Submit</button></span></div></form></div><div class="row mt-5 p-col"><form id=delete-form><div class="form-group input-group"><div class=input-group-prepend><div class="input-group-text input-group-text-info">Delete folder/file</div></div><input class="form-control mr-3"id=delete-entry name=delete-file placeholder=path/to/folder required> <span class=input-group-btn><button class="btn stylish-color btn-form"type=submit id=btnDelete>Submit</button></span></div></form></div></div><div class="fade tab-pane"id=database role=tabpanel aria-labelledby=database-tab><div class="row justify-content-center"><div class=col-xs-smaller-12><div class=btn-group role=group aria-label="Adminer Group"><button class="btn stylish-success"type=button id=btnAdminerOn>Enable Adminer</button> <button class="btn stylish-color"type=button id=btnAdminerGo onclick=openAdminer()>Go To Adminer</button> <button class="btn stylish-warning"type=button id=btnAdminerOff>Disable Adminer</button></div></div></div></div></div><div class="mt-5 col-xl-smaller-6"><div class="row d-none mb-3"id=progress-row><div class=col-12><div class=progress id=progress-container style=height:23px></div></div></div><div class=row><div class="col-12 panel panel-primary"id=result-panel><div class=panel-heading><h3 class=panel-title>Progress Log</h3></div><div class=panel-body><ul class="border-bottom border-top list-group progress-log rounded scrollbar-secondary"id=progress-log></ul></div></div></div></div></div></div><div class="fade alert alert-dismissible d-none version-notification alert-success"id=version-new role=alert><strong>New version is out!</strong><br>Download it <a class=text-info href=https://debugger.nctool.me/debugger-generator.php>here</a> <button class=close type=button aria-label=Close data-dismiss=alert><span aria-hidden=true>×</span></button></div><div class="fade alert alert-dismissible d-none version-notification alert-danger"id=version-fail role=alert><strong>Failed to check new version</strong> <button class=close type=button aria-label=Close data-dismiss=alert><span aria-hidden=true>×</span></button></div> <?php else: ?> <body style=text-align:center><div style=padding-top:25vh><form id=login-form style=display:inline-block><input class="form-control mb-0 mx-auto"id=password name=password placeholder=Password style=width:200px type=password> <small class="d-none form-text text-danger"id=password-invalid></small> <button class="btn unique-color mt-3"type=submit id=btnLogin>LOG IN</button></form></div> <?php endif; ?> <script src=https://cdnjs.cloudflare.com/ajax/libs/mdbootstrap/4.8.8/js/mdb.min.js></script>